<?php
/* --------------------------------------------------------------
   UserConfigurationServiceProvider.php 2020-02-13
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\UserConfiguration;

use Doctrine\DBAL\Connection;
use Gambio\Core\Application\ValueObjects\UserPreferences;
use Gambio\Admin\UserConfiguration\CurrentUserConfigurationService as CurrentUserConfigurationServiceImpl;
use Gambio\Admin\UserConfiguration\Interfaces\CurrentUserConfigurationService;
use Gambio\Admin\UserConfiguration\Interfaces\UserConfigurationRepository;
use Gambio\Admin\UserConfiguration\Repository\UserConfigurationReader;
use Gambio\Admin\UserConfiguration\Repository\UserConfigurationRepository as UserConfigurationRepositoryImpl;
use Gambio\Admin\UserConfiguration\Repository\UserConfigurationWriter;
use Gambio\Core\Application\ServiceProviders\Abstraction\AbstractServiceProvider;

/**
 * Class UserConfigurationServiceProvider
 *
 * @package Gambio\Core\ServiceProvider
 */
class UserConfigurationServiceProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            UserConfigurationRepository::class,
            CurrentUserConfigurationService::class,
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->share(UserConfigurationReader::class)->addArgument(Connection::class);
        $this->application->share(UserConfigurationWriter::class)->addArgument(Connection::class);
        
        $this->application->share(UserConfigurationRepository::class, UserConfigurationRepositoryImpl::class)
                          ->addArgument(UserConfigurationReader::class)
                          ->addArgument(UserConfigurationWriter::class);
        
        $this->application->share(CurrentUserConfigurationService::class, CurrentUserConfigurationServiceImpl::class)
                          ->addArgument(UserPreferences::class)
                          ->addArgument(UserConfigurationRepository::class);
    }
}